﻿<%@ Page Language="C#" AutoEventWireup="true" CodeFile="Default.aspx.cs" Inherits="_Default" %>

<%@ Register Assembly="AjaxControlToolkit" Namespace="AjaxControlToolkit" TagPrefix="cc1" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title></title>
    <style type="text/css">
        .modalBackground {
            background-color:Blue;
            filter:alpha(opacity=50);
            opacity:0.5;
        }
        
        .dialog
        {
            border-left:5px solid #fff; border-right:5px solid #fff;
            border-top:5px solid #fff; border-bottom:5px solid #fff;
            background:#ccc;
            padding: 10px;
            width: 350px;
        }
        
    </style>

    <script type="text/javascript">
        var _source;
        var _popup;

        function displayPopup(source) {
            _source = source;
            _popup = $find('popupDialog');
            //---display the popup dialog---
            _popup.show();
        }

        function OK_Click() {
            //---hides the popup dialog---
            _popup.hide();
            //---posts back to the server---
            __doPostBack(_source.name, '');
        }

        function No_Click() {
            //---hides the popup---
            _popup.hide();
            //---clears the event sourcesss
            _source = null;
            _popup = null;
        }
    </script>

</head>
<body>
    <form id="form1" runat="server">
    <div>
         <asp:ScriptManager ID="ScriptManager1" runat="server">
        </asp:ScriptManager>
        Wyświetlanie książek według wydawców:
        <asp:DropDownList ID="DropDownList1" runat="server" DataSourceID="LinqDataSource2"
            DataTextField="pub_name" DataValueField="pub_id" AutoPostBack="True" OnSelectedIndexChanged="DropDownList1_SelectedIndexChanged">
        </asp:DropDownList>
        
       
        <asp:UpdatePanel ID="UpdatePanel1" runat="server">
            <Triggers>
                <asp:AsyncPostBackTrigger ControlID="DropDownList1" EventName="SelectedIndexChanged" />
            </Triggers>
            <ContentTemplate>
                <asp:UpdateProgress ID="UpdateProgress1" runat="server">
                    <ProgressTemplate>
                        <asp:Label ID="Label1" runat="server" Text="Label">
                           Wyświetlanie listy książek...Proszę czekać.
                        </asp:Label>
                    </ProgressTemplate>
                </asp:UpdateProgress>
                <asp:GridView ID="GridView1" runat="server" AllowPaging="True" AllowSorting="True"
                    AutoGenerateColumns="False" BackColor="LightGoldenrodYellow" BorderColor="Tan"
                    BorderWidth="1px" CellPadding="2" DataKeyNames="title_id" DataSourceID="LinqDataSource1"
                    ForeColor="Black" GridLines="None">
                    <Columns>
                        <asp:CommandField ShowDeleteButton="False" ShowEditButton="True" ShowSelectButton="True" />
                        <asp:TemplateField ControlStyle-Width="50px" HeaderStyle-Width="60px" ItemStyle-HorizontalAlign="Center">
                            <ItemTemplate>
                                <asp:Button ID="btnDelete" runat="server" OnClick="btnDelete_Click" 
                                OnClientClick="displayPopup(this); return false;"
                                    Text="Delete" />
                            </ItemTemplate>
                        </asp:TemplateField>
                        <asp:BoundField DataField="title_id" HeaderText="title_id" ReadOnly="True" SortExpression="title_id" />
                        <asp:BoundField DataField="title1" HeaderText="title1" SortExpression="title1" />
                        <asp:BoundField DataField="type" HeaderText="type" SortExpression="type" />
                        <asp:TemplateField HeaderText="Publisher">
                            <ItemTemplate>
                                <%#Eval("publisher.pub_name")%>
                            </ItemTemplate>
                            <EditItemTemplate>
                                <asp:DropDownList ID="DropDownList2" DataSourceID="LinqDataSource2" DataTextField="pub_name"
                                    DataValueField="pub_id" SelectedValue='<%#Bind("pub_id")%>' runat="server">
                                </asp:DropDownList>
                            </EditItemTemplate>
                        </asp:TemplateField>
                        <asp:BoundField DataField="price" HeaderText="price" SortExpression="price" />
                        <asp:BoundField DataField="pubdate" HeaderText="pubdate" SortExpression="pubdate" />
                    </Columns>
                    <FooterStyle BackColor="Tan" />
                    <PagerStyle BackColor="PaleGoldenrod" ForeColor="DarkSlateBlue" HorizontalAlign="Center" />
                    <SelectedRowStyle BackColor="DarkSlateBlue" ForeColor="GhostWhite" />
                    <HeaderStyle BackColor="Tan" Font-Bold="True" />
                    <AlternatingRowStyle BackColor="PaleGoldenrod" />
                </asp:GridView>
            </ContentTemplate>
        </asp:UpdatePanel>
        <asp:LinqDataSource ID="LinqDataSource1" runat="server" ContextTypeName="DataClassesDataContext"
            EnableDelete="True" EnableInsert="True" EnableUpdate="True" TableName="titles"
            Where="pub_id == @pub_id">
            <WhereParameters>
                <asp:ControlParameter ControlID="DropDownList1" Name="pub_id" PropertyName="SelectedValue"
                    Type="String" />
            </WhereParameters>
        </asp:LinqDataSource>
        <asp:LinqDataSource ID="LinqDataSource2" runat="server" ContextTypeName="DataClassesDataContext"
            OrderBy="pub_name" Select="new (pub_name, pub_id)" TableName="publishers">
        </asp:LinqDataSource>
    </div>

    
    <div id="divDialog" runat="server" class="dialog" style="display: none">
        <center>
            <img style="vertical-align: middle" src="images/delete.png" width="60" />
			    Na pewno chcesz usunąć ten wiersz?<br />
            <asp:Button ID="btnOK" runat="server" Text="Yes" Width="50px" />
            <asp:Button ID="btnNO" runat="server" Text="No" Width="50px" />
        </center>
    </div>
    
    <cc1:ModalPopupExtender 
        ID="popupDialog" runat="server" TargetControlID="divDialog"
        PopupControlID="divDialog" OkControlID="btnOK" CancelControlID="btnNO" OnOkScript="OK_Click();"
        OnCancelScript="No_Click();" BackgroundCssClass="modalBackground">
    </cc1:ModalPopupExtender>
    
    
    </form>
</body>
</html>
